//Esercizio: implementare il metodo shiftSx, che prende in input un array 
//ed esegue uno spostamento dei suoi elementi verso sinistra
//suggerimento: prendere spunto dal metodo shiftDx
public class ArrayShift 
{
    public static void main(String args[])
    {
        ArrayShift as = new ArrayShift();

        int[] a1 = {1, 2, 3, 4, 5};
        //invocazione dei metodi per shiftare l'array
        as.printArray(a1, "a1");
        as.shiftSx(a1);
        as.printArray(a1, "a1 dopo shift a sinistra");
        
        as.shiftDx(a1);
        as.printArray(a1, "a1 dopo shift a destra");
        as.shiftDx(a1);
        as.printArray(a1, "a1 dopo 2 shift a destra");
    }

    //funzione che esegue lo shift a sinistra di un array
    private void shiftSx(int[] arr) {
        //si salva il primo elemento, che sarà spostato in ultima posizione
        int primoElem = arr[0];
        //partendo da sinistra, in ogni posizione si copia l'elemento della posizione successiva
        for(int i = 0; i < arr.length -1; i++)
            arr[i] = arr[i + 1];
        arr[arr.length -1] = primoElem;
    }
    
    //funzione che esegue lo shift a destra di un array
    private void shiftDx(int[] arr) {
        //si salva l'ultimo elemento, che sarà spostato in prima posizione
        int ultimoElem = arr[arr.length -1];
        //partendo da destra, in ogni posizione si copia l'elemento della posizione precedente
        for(int i = arr.length -1; i > 0; i--)
            arr[i] = arr[i - 1];
        arr[0] = ultimoElem;
    }
    
    public void printArray(int[] arr, String name, int start, int end)
    {
        System.out.print(name + "[" + start + ", " + end + "] = {");
        if(arr.length > 0) {
            for(int i = start; i < end; i++)
            {
                System.out.print(arr[i] + ", ");
            }
            System.out.print(arr[end]);
        }
        System.out.println("}");
    }
    
    public void printArray(int[] arr, String name)
    {
        printArray(arr, name, 0, arr.length-1);
    }
}
